/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.ftbsbc.dimensions.level.stoneblock;

import dev.ftb.ftbsbc.FTBStoneBlock;
import dev.ftb.ftbsbc.dimensions.kubejs.StoneBlockDataKjs;
import dev.ftb.ftbsbc.dimensions.level.stoneblock.StartStructurePiece;
import dev.ftb.ftbsbc.dimensions.level.stoneblock.StoneblockChunkGenerator;
import dev.ftb.ftbsbc.dimensions.prebuilt.PrebuiltStructure;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class StartStructure
extends StructureFeature<JigsawConfiguration> {
    public StartStructure() {
        super(JigsawConfiguration.f_67756_, StartStructure::generatePieces0);
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    private static Optional<PieceGenerator<JigsawConfiguration>> generatePieces0(PieceGeneratorSupplier.Context<JigsawConfiguration> context0) {
        int x = context0.f_197355_().m_45604_();
        int z = context0.f_197355_().m_45605_();
        if (x == 0 && z == 0) {
            return StartStructure.generatePieces(context0);
        }
        return Optional.empty();
    }

    private static Optional<PieceGenerator<JigsawConfiguration>> generatePieces(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        StructureManager structureManager = context.f_197359_();
        ChunkGenerator chunkGenerator = context.f_197352_();
        if (!(chunkGenerator instanceof StoneblockChunkGenerator)) {
            return Optional.empty();
        }
        StoneblockChunkGenerator stoneblockChunkGenerator = (StoneblockChunkGenerator)chunkGenerator;
        ChunkPos chunkPos = context.f_197355_();
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_190068_(context.f_197354_(), chunkPos.f_45578_, chunkPos.f_45579_);
        PrebuiltStructure start = StoneBlockDataKjs.PREBUILT_STRUCTURES.get(stoneblockChunkGenerator.prebuiltStructure.toString());
        if (start == null) {
            FTBStoneBlock.LOGGER.warn("Unable to find [{}] in the prebuild structure list", (Object)stoneblockChunkGenerator.prebuiltStructure.toString());
            return Optional.empty();
        }
        StructureTemplate template = structureManager.m_74341_(start.id);
        StructurePlaceSettings placeSettings = StartStructurePiece.makeSettings(template);
        BlockPos spawnPos = StartStructure.locateSpawn(template, placeSettings);
        int x = -spawnPos.m_123341_();
        int y = -spawnPos.m_123342_();
        int z = -spawnPos.m_123343_();
        BlockPos blockPos = new BlockPos(x, y, z);
        return Optional.of((builder, ctxt) -> builder.m_142679_((StructurePiece)new StartStructurePiece(structureManager, start.id, blockPos, template)));
    }

    public static BlockPos locateSpawn(StructureTemplate template, StructurePlaceSettings placeSettings) {
        BlockPos spawnPos = BlockPos.f_121853_;
        for (StructureTemplate.StructureBlockInfo info : template.m_74603_(BlockPos.f_121853_, placeSettings, Blocks.f_50677_)) {
            if (info.f_74677_ == null || StructureMode.valueOf((String)info.f_74677_.m_128461_("mode")) != StructureMode.DATA) continue;
            FTBStoneBlock.LOGGER.info("Found data block at [{}] with data [{}]", (Object)info.f_74675_, (Object)info.f_74677_.m_128461_("metadata"));
            if (!info.f_74677_.m_128461_("metadata").equalsIgnoreCase("spawn_point")) continue;
            spawnPos = info.f_74675_;
        }
        return spawnPos;
    }
}

